#include <stdio.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <wait.h>

#define MP3DIR "/mnt/Share/Music"
#define MAX_PATH 1024

#define F_LONG    0x01
#define F_ONE     0x08

typedef struct _MP3_NODE {
    char *name;
    struct _MP3_NODE *next;
} MP3NODE;

int my_comp(const void *a, const void *b)
{
    char *p, *q;
    p = (*(char **)a);
    q = (*(char **)b);

    return strcmp(p, q);
}

char **make_array(MP3NODE *top)
{
    MP3NODE *tmp, *work;
    char **ret;
    int i;

    tmp = top;
    i = 0;
    while( tmp ) {
        i++;
        tmp = tmp->next;
    }
    ret = (char **)malloc( sizeof(char *) * (i + 1));
    if( !ret )
        return NULL;
    tmp = top;
    i = 0;
    while( tmp ) {
        ret[i++] = tmp->name;
        work = tmp;
        tmp = tmp->next;
        free(work);
    }
    ret[i] = NULL;

    return ret;
}

int add_node(char *dir_name, MP3NODE **top)
{
    MP3NODE *tmp, *buff;
    char *name;

    buff = (MP3NODE *)malloc(sizeof(MP3NODE));
    if( !buff )
        return 0;
    name = malloc(strlen(dir_name)+1);
    if( !name )
        return 0;
    strcpy(name, dir_name);
    buff->name = name;
    buff->next=NULL;
    if( !(*top) )
        *top = buff;
    else {
        tmp = *top;
        while( tmp ) {
            if( !(tmp->next) ) {
                tmp->next = buff;
                break;
            }
            tmp = tmp->next;
        }
        return 1;
    }
}

int check_mp3(char *dir)
{
    DIR *dp;
    struct dirent *de;
    struct stat buff;
    char path[MAX_PATH];
    int len;
    time_t t;

    if( !(dp = opendir(dir)) )
        return 0;

    while( (de = readdir(dp)) ) {
        if( de->d_name[0] == '.' )
            continue;
        sprintf(path, "%s/%s", dir, de->d_name);
        if( stat(path, &buff) == -1 )
            continue;
        if( S_ISDIR(buff.st_mode) )
            continue;
        len = strlen(de->d_name) - 4;
        if( strcmp(".mp3", de->d_name + len) )
            continue;
        else
            return 1;
    }
    return 0;
}

void get_dir(char *dir, MP3NODE **top)
{
    DIR *dp;
    struct dirent *de;
    struct stat buff;
    char path[MAX_PATH];

    if( !(dp = opendir(dir)) )
        return;

    while( (de = readdir(dp)) ) {
        if( de->d_name[0] == '.' )
            continue;
        sprintf(path, "%s/%s", dir, de->d_name);
        if( stat(path, &buff) == -1 )
            continue;
        if( S_ISDIR(buff.st_mode) ) {
            if( check_mp3(path) )
                add_node(path, top);
            get_dir(path, top);
        }
    }
    return;
}

void free_list(char **list)
{
    int i;

    for( i = 0; list[i]; i++ )
        free(list[i]);
    free(list);
}

int main(int argc, char *argv[])
{
    MP3NODE *top = NULL;
    char **dir_list;
    char **mp3_list;
    char *dir_path = MP3DIR;
    int i, j, n, ret;
    int start = 0;
    int flag = 0;

    /* Argument */
    while( argc > 1 ) {
        if( *argv[1] == '-' && isdigit(*(argv[1]+1)) ) {
            start= atoi(argv[1]+1) - 1;
        } else if( *argv[1] == '-' ) {
            for( i = 1; *(argv[1]+i); i++ ) {
                switch( *(argv[1]+i) ) {
                case 'l':
                case 'L':
                    flag |= F_LONG;
                    break;
                case 'o':
                case 'O':
                    flag |= F_ONE;
                    break;
                }
            }
        } else {
            dir_path = argv[1];
        }
        argv++, argc--;
    }

    /* Make Playlist */
    get_dir(dir_path, &top);
    if( !(dir_list = make_array(top)) )
        return 1;
    for( n = 0; dir_list[n]; n++ );
    if( start > n )
        start = n - 1;

    /* Sort */
    qsort((void *)dir_list, n, sizeof(char *), my_comp);

    /* output */
    n = strlen(dir_path)+1;
    for( i = start; dir_list[i]; i++ ) {
        if( flag & F_LONG )
            printf("%s\n", dir_list[i]);
        else
            printf("%s\n", dir_list[i] + n);
    }
    free_list(dir_list);
    return 0;
}
